@echo off

setlocal enabledelayedexpansion

set service=wuauserv
set minversion=v14.0.24212.00
set installedversion=0

set operation=%1

if /I "%operation%"=="install" (
	:: Get the installed version of the VC++ Redistributable from the Registry
	for /f "tokens=3" %%T in ('reg query HKLM\SOFTWARE\Microsoft\VisualStudio\14.0\VC\Runtimes\x64 /v Version') do set installedversion=%%T

	if /I "%installedversion%" LSS "%minversion%" (
		:: Get and save the state of the Windows Update service
		for /F "tokens=3 delims=: " %%T in ('sc query %service% ^| findstr "STATE"') do (
			set state=%%T
		)

		:: Get and save the startup type of the Windows Update service
		for /F "tokens=3 delims=: " %%T in ('sc qc %service% ^| findstr "START_TYPE"') do (
			set startuptype=%%T
		)

		:: Set variable for startup type to pass into sc config later
		if "!startuptype!"=="AUTO_START" (
			for /F "tokens=4 delims=: " %%T in ('sc qc %service% ^| findstr "START_TYPE"') do (
				set autostarttype=%%T
			)

			if  "!autostarttype!"=="(DELAYED)" (
				set starttype=delayed-auto
			) else (
				set starttype=auto
			)
		) else if "!startuptype!"=="DEMAND_START" (
			set starttype=demand
		) else if "!startuptype!"=="DISABLED" (
			set starttype=disabled
		) else if "!startuptype!"=="BOOT" (
			set starttype=boot
		) else if "!startuptype!"=="SYSTEM" (
			set starttype=system
		)

		:: Stop the Windows Update service if it isn't already stopped
		if /I "!state!" NEQ "STOPPED" (
			REM sc stop %service%
			REM Use net stop since it's synchronous. sc stop is not.
			net stop %service% 
		)

		:: Disable the Windows Update service if it's not already disabled'
		if /I "!startuptype!" NEQ "DISABLED" (
			sc config %service% start= disabled
		)

		:: Run the VC++ Redistributable installer
		vc_redist.x64.exe /q /norestart

		:: Set the startup type to its orignal setting if it wasn't disabled
		if /I "!startuptype!" NEQ "DISABLED" (
			sc config %service% start= !starttype!
		)

		:: Start the Windows Update service if it was running originally
		if /I "!state!" NEQ "STOPPED" (
			sc start %service%
		)
	)
)

endlocal